import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedVisualProcessComponent = React.lazy(() => import('./visual-process-component'));
export function AsyncConnectedVisualProcessComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "400px" }) },
        React.createElement(ConnectedVisualProcessComponent, { ...props })));
}
const VisualProcessComponent = React.lazy(() => import('./visual-process-component').then(e => ({ default: e.VisualProcessComponent })));
export function AsyncVisualProcessComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: "400px" }) },
        React.createElement(VisualProcessComponent, { ...props })));
}
//# sourceMappingURL=async-visual-process-component.js.map