/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { TreeDecoratorProperties } from './tree-types';
/**
 * Initializes the decorated member as a [Tree]{@link TreeControlObject} field with the provided properties
 *
 * @param properties The properties that the [Tree]{@link TreeControlObject} field will be initialized with
 */
export declare function treeField<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any>(properties: TreeDecoratorProperties<Extend<CT>, ReferencedItemType>): (target: CT, name: string) => void;
//# sourceMappingURL=tree-decorator.d.ts.map