import type { CellFocusedEvent, ColumnEverythingChangedEvent, ColumnState, GridApi } from '@ag-grid-community/core';
import * as React from 'react';
import { ContextType } from '../../../types';
import type { OptionsMenuItem } from '../../container/page/page-types';
import type { InternalTableProperties, TableInternalComponentProps } from '../table/table-component-types';
import type { TreeDecoratorProperties } from './tree-types';
import type { AgGridColumnConfigWithScreenIdAndColDef } from '../../../utils/ag-grid/ag-grid-utility-types';
interface TreeDesktopState {
    columns: AgGridColumnConfigWithScreenIdAndColDef[];
    columnStates?: ColumnState[];
    hasFloatingFilters: boolean;
    isConfigurationDialogOpen?: boolean;
    phantomRows: any[];
    selectedOptionsMenuItem?: OptionsMenuItem;
    selectedRows: any[];
    tableHasData: boolean;
    autoGroupColumnDef?: AgGridColumnConfigWithScreenIdAndColDef;
}
export declare class DesktopTreeComponent extends React.Component<TableInternalComponentProps<any, TreeDecoratorProperties<any>>, TreeDesktopState> {
    private gridApi;
    private dataOperationMode;
    private actionSubscription;
    private collectionValueChangeSubscription;
    private collectionValidityChangeSubscription;
    protected containerRef: React.RefObject<HTMLDivElement>;
    private readonly defaultColDef;
    private readonly loadingCellRendererParams;
    constructor(props: TableInternalComponentProps<any, TreeDecoratorProperties<any>>);
    componentDidMount(): void;
    componentDidUpdate(prevProps: TableInternalComponentProps): void;
    componentWillUnmount(): void;
    private readonly getRowNode;
    private readonly onCollectionUpdated;
    private getCursor;
    private getFilters;
    /** Marks items selected on the table, this function is triggered by changes initiated by a pagination or reset
     * event
     **/
    private readonly selectTableItems;
    private readonly showHideNoRowsOverlay;
    private readonly insertDataSourceIntoTable;
    private readonly refreshHeader;
    private readonly updateColumnValidation;
    private readonly getUnknownLastRow;
    private readonly getRowCount;
    /**
     * Ag-grid callback which is triggered whenever the table component needs new data from our framework
     * @param getRowsParams
     */
    private readonly getRows;
    private readonly serverSideDataSource;
    private readonly isDisabled;
    private readonly isReadOnly;
    private readonly resizeListener;
    private readonly getTableViewColumnHidden;
    private readonly getTableViewFilter;
    private readonly getTableViewSortOrder;
    /**
     * Ag-grid lifecycle event listener. It is triggered when the table is prepared with the initial rendering of the
     * controller components and is ready to receive data.
     **/
    private readonly onGridReady;
    private readonly updateSelectedRows;
    private readonly getFilterModel;
    private readonly handleFilterChanged;
    private readonly setShouldResetTable;
    private readonly getRowId;
    private readonly getRowClass;
    private readonly gridOptions;
    private readonly getColumnDefinitions;
    private readonly hasFilterableColumns;
    private readonly toggleFloatingFilters;
    private readonly getServerSideGroupKey;
    private readonly getCacheBlockSize;
    private readonly isServerSideGroup;
    private readonly excludeInternalColumnsFilter;
    private readonly getAllColumnIds;
    private readonly getAllDisplayedColumnIds;
    autoSizeAllColumns: (gridApi?: GridApi | null) => void;
    private readonly onFirstDataRendered;
    private readonly sortColumns;
    private readonly getMainMenuItems;
    onCellFocused: (params: CellFocusedEvent) => void;
    getAllNotVisibleNotHiddenColumns: (tableProperties: InternalTableProperties) => string[];
    hideUnhideColumns: (event?: ColumnEverythingChangedEvent) => void;
    private readonly getTableHeight;
    private readonly noRowsOverlayComponentParams;
    private readonly onRowClicked;
    private readonly rowClassRules;
    initColumnState(): Promise<void>;
    render(): React.ReactNode;
}
export declare const ConnectedDesktopTableComponent: import("react-redux").ConnectedComponent<typeof DesktopTreeComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<DesktopTreeComponent> | undefined;
    bulkActions?: import("../../container/page/page-types").BulkAction[] | undefined;
    mobilePerformInitialLoadTableData?: boolean | undefined;
    searchText?: string | undefined;
    errorMessage?: string | undefined;
    isParentDisabled?: boolean | undefined;
    selectionMode?: "single" | "multiple" | undefined;
    skeletonHeight?: string | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    elementId: string;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedDesktopTableComponent;
//# sourceMappingURL=desktop-tree-component.d.ts.map