/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
 */
export declare class ToggleControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Toggle, FieldComponentProps<FieldKey.Toggle>> {
    static readonly defaultUiProperties: Partial<FieldComponentProps<FieldKey.Toggle>>;
    /** Options to be displayed in the select element */
    options?: string[];
    /**
     * The GraphQL node that the select options will be fetched from.
     * When using this property, the node must be an Enum
     */
    get optionType(): string | undefined;
    /** Moves the browser focus to this field */
    focus(): void;
    /** Field's value, only valid options can be set as value. */
    set value(newValue: ReferencedEnumType | null);
    /** Field's value, only valid options can be set as value. */
    get value(): ReferencedEnumType | null;
}
//# sourceMappingURL=toggle-control-object.d.ts.map