import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { TimeControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class TimeDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = TimeControlObject;
    }
}
/**
 * Initializes the decorated member as a [Time]{@link TimeControlObject} field with the provided properties.
 *
 * @param properties The properties that the [Time]{@link TimeControlObject} field will be initialized with.
 */
export function timeField(properties) {
    return standardDecoratorImplementation(properties, TimeDecorator, FieldKey.Time, true);
}
export function timeFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=time-decorator.js.map