var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { isNil } from 'lodash';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { TIME_REGEX, validateHours, validateMinutes } from '../../ui/time/time-utils';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
 * be matched against the user provided text.
 */
export class TimeControlObject extends EditableFieldControlObject {
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
    get hours() {
        const currentValue = this._getValue();
        if (isNil(currentValue)) {
            return null;
        }
        const [hours] = currentValue.split(':');
        return Number(hours);
    }
    set hours(value) {
        if (value < 0 || value > 23 || !Number.isInteger(value)) {
            throw new Error('Invalid hours');
        }
        const currentValue = this._getValue();
        const [, minutes, seconds] = (currentValue ?? '00:00:00').split(':');
        this._setValue(`${String(value).padStart(2, '0')}:${minutes}:${seconds}`);
    }
    get minutes() {
        const currentValue = this._getValue();
        if (isNil(currentValue)) {
            return null;
        }
        const [, minutes] = currentValue.split(':');
        return Number(minutes);
    }
    set minutes(value) {
        if (value < 0 || value > 59 || !Number.isInteger(value)) {
            throw new Error('Invalid minutes');
        }
        const currentValue = this._getValue();
        const [hours, , seconds] = (currentValue ?? '00:00:00').split(':');
        this._setValue(`${hours}:${String(value).padStart(2, '0')}:${seconds}`);
    }
    get seconds() {
        const currentValue = this._getValue();
        if (isNil(currentValue)) {
            return null;
        }
        const [, , seconds] = currentValue.split(':');
        return Number(seconds);
    }
    set seconds(value) {
        if (value < 0 || value > 59 || !Number.isInteger(value)) {
            throw new Error('Invalid seconds');
        }
        const currentValue = this._getValue();
        const [hours, minutes] = (currentValue ?? '00:00:00').split(':');
        this._setValue(`${hours}:${minutes}:${String(value).padStart(2, '0')}`);
    }
    get value() {
        return this._getValue();
    }
    set value(value) {
        if (isNil(value)) {
            this._setValue(null);
            return;
        }
        const match = value.match(TIME_REGEX);
        if (!match) {
            throw new Error(`Invalid time: ${value}`);
        }
        const hoursValidation = validateHours({ hours: match[1], hasAmPmToggle: false, toggle: 'unknown' });
        const minutesValidation = validateMinutes(match[2]);
        if (!hoursValidation.isValid || !minutesValidation.isValid) {
            throw new Error(`Invalid time: ${value}`);
        }
        this._setValue(value);
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], TimeControlObject.prototype, "helperText", void 0);
//# sourceMappingURL=time-control-object.js.map