import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedTimeComponent = React.lazy(() => import('./time-component'));
export function AsyncConnectedTimeComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedTimeComponent, { ...props })));
}
const TimeComponent = React.lazy(() => import('./time-component').then(c => ({ default: c.TimeComponent })));
export function AsyncTimeComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(TimeComponent, { ...props })));
}
//# sourceMappingURL=async-time-component.js.map