/**
 * @packageDocumentation
 * @module root
 * */
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a single-line text value
 */
export declare class TextControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Text, FieldComponentProps<FieldKey.Text>> {
    /** The helper text underneath the field */
    helperText?: string;
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Icon of the input field. It will be placed on the right side. */
    iconColor?: string;
    /** The minimum length of the text field value */
    minLength?: number;
    /**  The maximum length of the text field value  */
    maxLength?: number;
    /** The helper text underneath the field */
    placeholder?: string;
    /** Text to be displayed inline after the field value */
    prefix?: string;
    /** Text to be displayed inline before the field value */
    postfix?: string;
    /** The type of input field */
    isPassword?: boolean;
}
//# sourceMappingURL=text-control-object.d.ts.map