import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { BaseEditableComponentProperties, NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { TextDecoratorProperties } from './text-types';
type TextComponentProps = BaseEditableComponentProperties<TextDecoratorProperties, string, NestedFieldsAdditionalProperties & {
    isDirty?: boolean;
}>;
export interface TextComponentState {
    value: string;
    isDirty: boolean;
    autocompleteText: string;
    autocompletePosition?: number | null;
}
export declare class TextComponent extends EditableFieldBaseComponent<TextDecoratorProperties, string, NestedFieldsAdditionalProperties, TextComponentState> {
    constructor(props: TextComponentProps);
    private readonly onInputValueChanged;
    private readonly onChange;
    private readonly onBlur;
    private readonly onKeyDown;
    private readonly onKeyUp;
    private readonly onClick;
    UNSAFE_componentWillReceiveProps(nextProps: TextComponentProps): void;
    private readonly handleFocus;
    private readonly handleSelection;
    private readonly getValueWidth;
    render(): React.ReactNode;
}
export declare const ConnectedTextComponent: import("react-redux").ConnectedComponent<typeof TextComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<TextComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    screenId: string;
    parentElementId?: string | undefined;
    level?: number | undefined;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedTextComponent;
//# sourceMappingURL=text-component.d.ts.map