import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { TextAreaDecoratorProperties } from './text-area-types';
/**
 * Initializes the decorated member as a [TextArea]{@link TextAreaControlObject} field with the provided properties
 *
 * @param properties The properties that the [TextArea]{@link TextAreaControlObject} field will be initialized with
 */
export declare function textAreaField<T extends ScreenExtension<T>>(properties: TextAreaDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function textAreaFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<TextAreaDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=text-area-decorator.d.ts.map