/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a multi-line text value
 */
export declare class TextAreaControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.TextArea, FieldComponentProps<FieldKey.TextArea>> {
    /** The number of rows the text area will span */
    rows?: number;
    /** The minimum length of the text field value */
    minLength?: number;
    /**  The maximum length of the text field value  */
    maxLength?: number;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** The helper text underneath the field */
    helperText?: string;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=text-area-control-object.d.ts.map