import Textarea from 'carbon-react/esm/components/textarea';
import * as React from 'react';
import { connect } from 'react-redux';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { getCommonCarbonComponentProperties } from '../carbon-helpers';
import { CarbonWrapper } from '../carbon-wrapper';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
export class TextAreaComponent extends EditableFieldBaseComponent {
    constructor(props) {
        super(props);
        this.onChange = (event) => {
            this.setState({ value: event.target.value });
        };
        this.onBlur = () => {
            const carbonProps = getCommonCarbonComponentProperties(this.props);
            carbonProps.onBlur();
            const newValue = this.state.value || null;
            const propsValue = this.props.value || null;
            if (newValue !== propsValue) {
                handleChange(this.props.elementId, newValue, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
            }
        };
        this.onKeyDown = (event) => {
            if (event.key === 'Escape') {
                this.setState({ value: this.props.value || '' });
            }
        };
        this.state = { value: this.props.value || '' };
    }
    UNSAFE_componentWillReceiveProps(nextProps) {
        const value = nextProps.value;
        if (this.state.value !== value) {
            this.setState({ value: value || '' });
        }
    }
    getFocusableElement(element) {
        return element.querySelector('textarea');
    }
    render() {
        return (React.createElement(CarbonWrapper, { ...this.props, className: "e-text-area-field", componentName: "text-area", componentRef: this.componentRef, noReadOnlySupport: true, value: this.state.value },
            React.createElement(Textarea, { ...getCommonCarbonComponentProperties(this.props), onChange: this.onChange, onBlur: this.onBlur, onClick: this.getClickHandler(), onKeyDown: this.onKeyDown, value: this.state.value, rows: this.props.fieldProperties.rows })));
    }
}
export const ConnectedTextAreaComponent = connect(mapStateToProps(), mapDispatchToProps())(TextAreaComponent);
export default ConnectedTextAreaComponent;
//# sourceMappingURL=text-area-component.js.map