import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { BaseEditableComponentProperties } from '../field-base-component-types';
import type { TextAreaDecoratorProperties } from './text-area-types';
type TextAreaComponentProps = BaseEditableComponentProperties<TextAreaDecoratorProperties, string>;
export interface TextAreaComponentState {
    value: string;
}
export declare class TextAreaComponent extends EditableFieldBaseComponent<TextAreaDecoratorProperties, string, {}, TextAreaComponentState> {
    constructor(props: TextAreaComponentProps);
    onChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onBlur: () => void;
    onKeyDown: (event: KeyboardEvent) => void;
    UNSAFE_componentWillReceiveProps(nextProps: TextAreaComponentProps): void;
    getFocusableElement(element: HTMLElement): HTMLTextAreaElement | null;
    render(): React.ReactNode;
}
export declare const ConnectedTextAreaComponent: import("react-redux").ConnectedComponent<typeof TextAreaComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<TextAreaComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    screenId: string;
    parentElementId?: string | undefined;
    level?: number | undefined;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedTextAreaComponent;
//# sourceMappingURL=text-area-component.d.ts.map