import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { TechnicalJsonControlObject } from './technical-json-control-object';
class TechnicalJsonDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = TechnicalJsonControlObject;
    }
}
/**
 * Initializes the decorated member as a [TechnicalJsonDecorator]{@link TechnicalJsonDecoratorControlObject} field with the provided properties.
 *
 * @param properties The properties that the [TechnicalJsonDecorator]{@link TechnicalJsonDecoratorControlObject} field will be initialized with.
 */
export function technicalJsonField(properties) {
    return standardDecoratorImplementation(properties, TechnicalJsonDecorator, FieldKey.TechnicalJson);
}
export function technicalJsonFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=technical-json-decorator.js.map