import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { TechnicalJsonDecoratorProperties } from './technical-json-types';
/**
 * Initializes the decorated member as a [TechnicalJsonDecorator]{@link TechnicalJsonDecoratorControlObject} field with the provided properties.
 *
 * @param properties The properties that the [TechnicalJsonDecorator]{@link TechnicalJsonDecoratorControlObject} field will be initialized with.
 */
export declare function technicalJsonField<T extends ScreenExtension<T>>(properties: TechnicalJsonDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function technicalJsonFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<TechnicalJsonDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=technical-json-decorator.d.ts.map