/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { TableDecoratorProperties, TableExtensionDecoratorProperties } from './table-component-types';
/**
 * Initializes the decorated member as a [Table]{@link TableControlObject} field with the provided properties
 *
 * @param properties The properties that the [Table]{@link TableControlObject} field will be initialized with
 */
export declare function tableField<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any>(properties: TableDecoratorProperties<Extend<CT>, ReferencedItemType>): (target: CT, name: string) => void;
export declare function tableFieldOverride<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any>(properties: TableExtensionDecoratorProperties<CT, ReferencedItemType>): (target: CT, name: string) => void;
//# sourceMappingURL=table-decorator.d.ts.map