var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { uniq, without } from 'lodash';
import { getStore } from '../../../redux';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import { TableDisplayMode } from '../../types';
import { CollectionValueControlObject } from '../collection-value-field';
import { openTableSidebar } from '../../../redux/actions';
import { getNestedFieldsFromProperties } from '../../../utils/nested-field-utils';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a set of values of any type. It can contain nested fields
 */
export class TableControlObject extends CollectionValueControlObject {
    static { this.defaultUiProperties = {
        ...ReadonlyFieldControlObject.defaultUiProperties,
        canAddNewLine: false,
        canExport: false,
        canFilter: true,
        canResizeColumns: false,
        canSelect: true,
        canUserHideColumns: true,
        displayMode: TableDisplayMode.comfortable,
        fetchesDefaults: false,
        isPhantomRowDisabled: false,
        isReadOnly: false,
        mainField: '_id',
        pageSize: 20,
    }; }
    /** Whether user can hide columns or not  */
    get canUserHideColumns() {
        const propertyValue = this.getUiComponentProperty('canUserHideColumns');
        return propertyValue === undefined ? true : propertyValue;
    }
    /** Whether user can hide columns or not  */
    set canUserHideColumns(newValue) {
        this.setUiComponentProperties('canUserHideColumns', newValue);
    }
    hideColumn(columnBind) {
        const currentValue = this.getUiComponentProperty('hiddenColumns') || [];
        this.setUiComponentProperties('hiddenColumns', uniq([...currentValue, columnBind]));
    }
    showColumn(columnBind) {
        const currentValue = this.getUiComponentProperty('hiddenColumns') || [];
        this.setUiComponentProperties('hiddenColumns', without(currentValue, columnBind));
    }
    /** Return records that the user just added to this table and not yet known by the server. */
    getNewRecords() {
        this.ensureFieldHasValue();
        const value = this._getValue();
        if (!value) {
            return [];
        }
        return value.getNewRecords();
    }
    get node() {
        return String(this.getUiComponentProperty('node'));
    }
    /** Redraws the current table view, this function can be useful when values are updated that are used in property callbacks. */
    redraw(columnBind) {
        return this._redraw(columnBind);
    }
    openSidebar(recordId) {
        const dispatch = getStore().dispatch;
        dispatch(openTableSidebar({
            cardDefinition: this.properties.mobileCard,
            columns: getNestedFieldsFromProperties(this.properties),
            elementId: this.elementId,
            recordId,
            screenId: this.screenId,
            sidebarDefinition: this.properties.sidebar,
        }));
    }
    refresh(keepModifications = false) {
        const state = getStore().getState();
        const openSidebarDialogContent = Object.values(state.activeDialogs).some(dialog => dialog.screenId === this.screenId &&
            dialog.type === 'table-sidebar' &&
            dialog.content.elementId === this.elementId);
        if (openSidebarDialogContent) {
            throw new Error('Tables cannot be refreshed while the sidebar is open');
        }
        return super.refresh(keepModifications);
    }
}
__decorate([
    ControlObjectProperty()
    /** Whether all table columns can be resized or not */
], TableControlObject.prototype, "canResizeColumns", void 0);
__decorate([
    ControlObjectProperty()
    /** Whether the rows of this table can be filtered or not */
], TableControlObject.prototype, "canFilter", void 0);
__decorate([
    ControlObjectProperty()
    /** Whether the "phantom row" will be displayed or not */
], TableControlObject.prototype, "isPhantomRowDisabled", void 0);
__decorate([
    ControlObjectProperty()
    /** Whether the rows of this table can be filtered or not */
], TableControlObject.prototype, "isReadOnly", void 0);
//# sourceMappingURL=table-control-object.js.map