import * as React from 'react';
import type { NestedRecordId } from '../../../types';
import type { CollectionItem } from '../../types';
import type { TableComponentProps } from './table-component-types';
import type { DesktopTableComponent } from './desktop-table-component';
export declare const TableComponent: React.ForwardRefExoticComponent<TableComponentProps & React.RefAttributes<DesktopTableComponent>>;
export declare class TableComponentInternal extends React.Component<TableComponentProps> {
    componentDidMount(): void;
    getComponentClass: () => string;
    onRowClick: (recordId: NestedRecordId, newRecord?: CollectionItem, isModifierKeyPushed?: boolean) => () => void;
    render(): React.ReactNode;
}
export declare const ConnectedTableComponent: import("react-redux").ConnectedComponent<React.ForwardRefExoticComponent<TableComponentProps & React.RefAttributes<DesktopTableComponent>>, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<DesktopTableComponent> | undefined;
    bulkActions?: import("../../control-objects").BulkAction[] | undefined;
    mobilePerformInitialLoadTableData?: boolean | undefined;
    searchText?: string | undefined;
    errorMessage?: string | undefined;
    isParentDisabled?: boolean | undefined;
    selectionMode?: "single" | "multiple" | undefined;
    skeletonHeight?: string | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client/build/lib/client-node").ClientNode | any>;
    elementId: string;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../../../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedTableComponent;
//# sourceMappingURL=table-component.d.ts.map