import React from 'react';
import Preview from 'carbon-react/esm/components/preview';
import { GridColumn } from '@sage/xtrem-ui-components';
export const MobileTableSkeletonCard = React.memo(({ cardDefinition, availableColumns }) => (React.createElement(GridColumn, { columnSpan: availableColumns, className: "e-card", key: "4" },
    React.createElement("div", { className: "e-card-content e-card-content-skeleton" },
        React.createElement("div", { className: "e-card-content-skeleton-row" },
            React.createElement(Preview, { loading: true, width: "100%", height: "16px" })),
        (cardDefinition.line2 || cardDefinition.line2Right) && (React.createElement("div", { className: "e-card-content-skeleton-row" },
            React.createElement(Preview, { loading: true, width: "30%", height: "16px" }))),
        (cardDefinition.line3 || cardDefinition.line3Right) && (React.createElement("div", { className: "e-card-content-skeleton-row" },
            React.createElement(Preview, { loading: true, width: "80%", height: "16px" }))),
        (cardDefinition.line4 || cardDefinition.line4Right) && (React.createElement("div", { className: "e-card-content-skeleton-row" },
            React.createElement(Preview, { loading: true, width: "80%", height: "16px" }))),
        (cardDefinition.line5 || cardDefinition.line5Right) && (React.createElement("div", { className: "e-card-content-skeleton-row" },
            React.createElement(Preview, { loading: true, width: "80%", height: "16px" })))))));
MobileTableSkeletonCard.displayName = 'MobileTableSkeletonCard';
//# sourceMappingURL=mobile-table-skeleton-card.js.map