import { type Dict } from '@sage/xtrem-shared';
import React from 'react';
import type { OptionsMenuItem } from '../../container/page/page-types';
import type { TableInternalComponentProps } from './table-component-types';
import type { FormattedNodeDetails } from '../../../service/metadata-types';
import type { ReduxResponsive } from '../../../redux/state';
export interface MobileTableComponentState {
    hasMorePages: boolean;
    isFetchingNextPage?: boolean;
    isLoading?: boolean;
    pageNumber: number;
    searchText?: string;
    valuesDisplayed: any[];
}
export interface MobileTableProps extends TableInternalComponentProps {
    browser: ReduxResponsive;
    hasFieldActions: boolean;
    isRefreshing?: boolean;
    nodeTypes: Dict<FormattedNodeDetails>;
    openSidebar: () => void;
    selectedOptionsMenuItem?: OptionsMenuItem;
}
export declare class UnconnectedMobileTableComponent extends React.Component<MobileTableProps, MobileTableComponentState> {
    private readonly takeLatest;
    constructor(props: MobileTableProps);
    componentDidMount(): Promise<void>;
    componentDidUpdate(prevProps: Readonly<MobileTableProps>): Promise<void>;
    private getCursor;
    private readonly isNavigationPanel;
    private readonly toXtremFilters;
    private readonly isDisabled;
    private readonly isReadOnly;
    private readonly subscribeToCollectionValueEvents;
    private readonly onRowSelected;
    private readonly canCreateNewItem;
    private readonly getCreateNewItem;
    private readonly onRowClick;
    private readonly refreshTableContent;
    private readonly onFiltersChanged;
    private readonly getFilterableFields;
    private readonly fetchNextPage;
    private readonly getRows;
    private readonly getOptionsMenuType;
    private readonly onScroll;
    private readonly onKeyDown;
    private readonly onOptionsMenuItemChanged;
    private readonly onSearchBoxValueChange;
    private readonly onResetFilter;
    private renderMobileHeaderActions;
    private renderDesktopHeader;
    private renderOptionsMenu;
    private renderMobileSearchbox;
    private renderMobileHeader;
    render(): React.ReactNode;
}
//# sourceMappingURL=mobile-table-component.d.ts.map