import type { CellFocusedEvent, CellKeyDownEvent, ColDef, Column, ColumnEverythingChangedEvent, ColumnState, GridApi } from '@ag-grid-community/core';
import type { Dict } from '@sage/xtrem-shared';
import * as React from 'react';
import { ContextType } from '../../../types';
import type { AgGridColumnConfigWithScreenIdAndColDef } from '../../../utils/ag-grid/ag-grid-utility-types';
import type { OptionsMenuItem } from '../../container/page/page-types';
import type { CalendarView } from '../../ui/calendar-body/calendar-body-types';
import type { InternalTableProperties, TableInternalComponentProps, TableUserSettings, TableViewGrouping, TableViewSortedColumn } from './table-component-types';
interface ResizedColumn {
    key: string | Column;
    newWidth: number;
}
interface TableDesktopState {
    autoGroupColumnDef?: ColDef;
    columns: AgGridColumnConfigWithScreenIdAndColDef[];
    columnStates?: ColumnState[];
    groupByColumn?: AgGridColumnConfigWithScreenIdAndColDef;
    hasFloatingFilters: boolean;
    isConfigurationDialogOpen?: boolean;
    isExportingExcel: boolean;
    isSelectAllChecked: boolean;
    phantomRows: {
        _id: string;
    }[];
    selectedRowCount: number;
    selectedCalendarView: CalendarView;
    resizedColumns: ResizedColumn[];
    tableHasData: boolean;
}
export declare class DesktopTableComponent extends React.Component<TableInternalComponentProps, TableDesktopState> {
    private gridApi;
    private readonly gridId;
    private dataOperationMode;
    private readonly autoSizeStrategy;
    private isFetching;
    private isFilteringErrors;
    private actionSubscription;
    private collectionValueChangeSubscription;
    private collectionValidityChangeSubscription;
    protected containerRef: React.RefObject<HTMLDivElement>;
    private readonly defaultColDef;
    private readonly loadingCellRendererParams;
    private readonly loadingOverlayComponentParams;
    constructor(props: TableInternalComponentProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: TableInternalComponentProps): Promise<void>;
    componentWillUnmount(): void;
    getSelectionFilter(mode?: 'server' | 'client'): any;
    isSelectAllChecked(): boolean;
    private readonly getRowNode;
    private redrawLineNumbers;
    private readonly focusPhantomRowAndStartEditing;
    private readonly showHideNoRowsOverlay;
    private readonly onCollectionUpdated;
    private findLastLoadedRowData;
    private getCursor;
    private getFilters;
    private readonly applyTableView;
    private readonly resetOptionsMenu;
    private readonly insertDataSourceIntoTable;
    private readonly updateColumnValidation;
    private readonly getUnknownLastRow;
    private readonly getRowCount;
    private readonly isNavigationPanel;
    private readonly belongsToGroup;
    private readonly selectTableItems;
    /**
     * Ag-grid callback which is triggered whenever the table component needs new data from our framework
     * @param getRowsParams
     */
    private readonly getRows;
    private readonly serverSideDataSource;
    private readonly isDisabled;
    private readonly isReadOnly;
    private readonly resizeListener;
    private readonly onGridEvent;
    /**
     * Ag-grid lifecycle event listener. It is triggered when the table is prepared with the initial rendering of the
     * controller components and is ready to receive data.
     **/
    private readonly onGridReady;
    private readonly setPhantomRow;
    private readonly onSwitchView;
    private readonly onSwitchCalendarView;
    private readonly handleFilterChanged;
    private readonly handleColumnRowGroupChanged;
    private readonly setShouldResetTable;
    private readonly onOptionsMenuItemChange;
    private readonly getRowId;
    private readonly getRowClass;
    private readonly selectionColumnDef;
    private readonly gridOptions;
    private readonly getColumnDefinitions;
    private readonly hasFilterableColumns;
    private readonly toggleFloatingFilters;
    private readonly exportToExcelWithInfiniteScroll;
    private readonly exportToExcelWithPagination;
    private readonly exportToExcel;
    private readonly getCacheBlockSize;
    private readonly isServerSideGroup;
    private readonly excludeInternalColumnsFilter;
    private readonly getAllColumnIds;
    private readonly getAllDisplayedColumnIds;
    autoSizeAllColumns: (gridApi?: GridApi | null) => void;
    private readonly onFirstDataRendered;
    private readonly canBeGroupedBy;
    private readonly ungroupByColumn;
    private readonly groupByColumn;
    private readonly updateColDefsStates;
    private readonly sortColumns;
    private readonly getGroupByMenuItem;
    private readonly getMainMenuItems;
    isElementInViewport: (e: HTMLElement) => boolean;
    onCellFocused: (params: CellFocusedEvent) => void;
    onCellKeyDown: (event: CellKeyDownEvent) => void;
    getAllNotVisibleNotHiddenColumns: (tableProperties: InternalTableProperties) => string[];
    hideUnhideColumns: (event?: ColumnEverythingChangedEvent) => void;
    onFilterByErrors: () => Promise<void>;
    onUnsetFilterByErrors: () => Promise<void>;
    updateColumnState(): Promise<void>;
    private readonly onColumnPanelHiddenStateChange;
    private readonly getCurrentColumnOrder;
    private readonly moveStartIndex;
    private readonly onColumnPanelOrderChangeChange;
    private readonly onSortChanged;
    renderCalendarView(): React.ReactNode;
    private readonly onCellClicked;
    private readonly onCellEditingStopped;
    private readonly onColumnResized;
    private readonly onOpenColumnPanel;
    private readonly onCloseColumnPanel;
    private readonly noRowsOverlayComponentParams;
    private readonly onRowClicked;
    private readonly rowClassRules;
    private readonly isInfiniteScroll;
    initColumnState(): Promise<void>;
    private readonly getRowHeight;
    private readonly onUnselectAll;
    private readonly onSelectionChanged;
    private readonly getRowSelection;
    private readonly rowSelection;
    private readonly getTableHeight;
    render(): React.ReactNode;
}
export declare const ConnectedDesktopTableComponent: import("react-redux").ConnectedComponent<typeof DesktopTableComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<DesktopTableComponent> | undefined;
    accessBindings: import("../../../service/page-definition").AccessBindings;
    activeLookupDialog?: (import("../../../redux/state").FocusPosition | null) | undefined;
    additionalLookupRecords?: (() => import("../../types").PartialCollectionValueWithIds<any>[]) | undefined;
    api?: GridApi | undefined;
    availableColumns?: number | undefined;
    bulkActions?: import("../../control-objects").BulkAction[] | undefined;
    canDragCard?: boolean | undefined;
    contextType?: ContextType | undefined;
    dataTypes: Dict<import("../../../service/metadata-types").DataTypeDetails>;
    elementId: string;
    emptyStateClickableText?: string | undefined;
    emptyStateText?: string | undefined;
    enumTypes: Dict<string[]>;
    errorMessage?: string | undefined;
    fieldProperties: InternalTableProperties<import("../../../service/screen-base").ScreenBase<any, any>, any>;
    filterModel?: any;
    graphApi?: import("../../..").GraphQLApi<any> | undefined;
    groupByField?: import("../reference/reference-types").PropertyValueType;
    groupTitle?: string | undefined;
    isAutoSelectEnabled?: boolean | undefined;
    isInFocus?: boolean | undefined;
    isLookupDialog?: boolean | undefined;
    isNavPanel?: boolean | undefined;
    isParentDisabled?: boolean | undefined;
    isReadOnly?: import("../../../utils/types").ValueOrCallbackWithFieldValue<import("../../../service/screen-base").ScreenBase<any, any>, boolean>;
    isTableInFocus?: boolean | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    locale: import("@sage/xtrem-shared").LocalizeLocale;
    nodeTypes: Dict<import("../../../service/metadata-types").FormattedNodeDetails>;
    numberOfVisibleRows?: number | undefined;
    onEmptyStateClickableText?: (() => void) | undefined;
    onFocus?: ((screenId: string, elementId: string, row: string, nestedField: string) => void) | undefined;
    onRowClick?: import("./table-component-types").OnRowClickFunction | undefined;
    onTelemetryEvent?: import("../../../redux/state").OnTelemetryEventFunction | undefined;
    openedRecordId?: string | number | null | undefined;
    pageNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    saveCurrentView?: (() => void) | undefined;
    screenId: string;
    searchText?: string | undefined;
    selectedOptionsMenuItem?: OptionsMenuItem | undefined;
    selectedRecordId?: string | number | boolean | undefined;
    selectionMode?: "single" | "multiple" | undefined;
    setFieldProperties?: ((elementId: string, properties: InternalTableProperties<import("../../../service/screen-base").ScreenBase>) => void) | undefined;
    setGlobalLoading?: ((setGlobalLoading: boolean) => void) | undefined;
    setTableViewColumnHidden?: ((level: number, columnHidden?: Dict<boolean>) => void) | undefined;
    setTableViewColumnOrder?: ((level: number, columnOrder?: string[]) => void) | undefined;
    setTableViewFilter?: ((level: number, filter?: any) => void) | undefined;
    setTableViewGrouping?: ((level: number, grouping?: TableViewGrouping) => void) | undefined;
    setTableViewOptionsMenuItem?: ((level: number, optionsMenuItem?: OptionsMenuItem) => void) | undefined;
    setTableViewOptionsMenuItemAndViewFilter?: ((level: number, optionsMenuItem?: OptionsMenuItem, filter?: any) => void) | undefined;
    setTableViewSearchText?: ((level: number, searchText: string) => void) | undefined;
    setTableViewSortOrder?: ((level: number, sortOrder?: TableViewSortedColumn[]) => void) | undefined;
    skeletonHeight?: string | undefined;
    tableUserSettings?: Dict<TableUserSettings> | undefined;
    username?: string | undefined;
    validationErrors: import("../../../service/screen-base-definition").ValidationResult[];
    value: import("../../../service/collection-data-service").CollectionValue;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedDesktopTableComponent;
//# sourceMappingURL=desktop-table-component.d.ts.map