import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedTableComponent = React.lazy(() => import('./table-component'));
export function AsyncConnectedTableComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: props.skeletonHeight ?? '200px' }) },
        React.createElement(ConnectedTableComponent, { ...props })));
}
const TableComponentWithRef = React.lazy(() => import('./table-component').then(c => {
    const TableComponentWithRef = React.forwardRef((props, ref) => (React.createElement(c.TableComponent, { ref: ref, ...props })));
    TableComponentWithRef.displayName = 'TableComponentWithRef';
    return {
        default: TableComponentWithRef,
    };
}));
export const AsyncTableComponent = React.forwardRef((props, ref) => {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: props.skeletonHeight ?? '200px' }) },
        React.createElement(TableComponentWithRef, { ref: ref, ...props })));
});
AsyncTableComponent.displayName = 'AsyncTableComponent';
//# sourceMappingURL=async-table-component.js.map