import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const DesktopTableComponentWithRef = React.lazy(() => import('./desktop-table-component').then(({ default: DesktopTableComponent }) => {
    const TableComponentWithRef = React.forwardRef((props, ref) => React.createElement(DesktopTableComponent, { ref: ref, ...props }));
    TableComponentWithRef.displayName = 'DesktopTableComponentWithRef';
    return {
        default: TableComponentWithRef,
    };
}));
export const AsyncDesktopTableComponent = React.forwardRef((props, ref) => {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: props.skeletonHeight ?? '200px' }) },
        React.createElement(DesktopTableComponentWithRef, { ref: ref, ...props })));
});
AsyncDesktopTableComponent.displayName = 'AsyncDesktopTableComponent';
//# sourceMappingURL=async-desktop-table-component.js.map