/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { TableSummaryControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
import { addColumnsToProperties, addDisabledToProperties, addNodeToProperties } from '../../../utils/data-type-utils';
class TableSummaryDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = TableSummaryControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addNodeToProperties({ dataType, propertyDetails, properties });
        addColumnsToProperties({
            dataType,
            propertyDetails,
            properties,
            dataTypes: this.dataTypes,
            nodeTypes: this.nodeTypes,
        });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [TableSummary]{@link TableSummaryControlObject} field with the provided properties
 *
 * @param properties The properties that the [TableSummary]{@link TableSummaryControlObject} field will be initialized with
 */
export function tableSummaryField(properties) {
    return standardDecoratorImplementation(properties, TableSummaryDecorator, FieldKey.TableSummary, true);
}
export function tableSummaryFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=table-summary-decorator.js.map