/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { TableSummaryDecoratorProperties, TableSummaryExtensionDecoratorProperties } from './table-summary-types';
/**
 * Initializes the decorated member as a [TableSummary]{@link TableSummaryControlObject} field with the provided properties
 *
 * @param properties The properties that the [TableSummary]{@link TableSummaryControlObject} field will be initialized with
 */
export declare function tableSummaryField<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any>(properties: TableSummaryDecoratorProperties<Extend<CT>, ReferencedItemType>): (target: CT, name: string) => void;
export declare function tableSummaryFieldOverride<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any>(properties: TableSummaryExtensionDecoratorProperties<CT, ReferencedItemType>): (target: CT, name: string) => void;
//# sourceMappingURL=table-summary-decorator.d.ts.map