import Switch from 'carbon-react/esm/components/switch';
import * as React from 'react';
import { connect } from 'react-redux';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { triggerFieldEvent, triggerNestedFieldEvent } from '../../../utils/events';
import { getCommonCarbonComponentProperties, isFieldDisabled, isFieldReadOnly } from '../carbon-helpers';
import { CarbonWrapper } from '../carbon-wrapper';
import { mapDispatchToProps, mapStateToProps } from '../field-base-utils';
import { localize } from '../../../service/i18n-service';
export const SwitchComponent = React.memo((props) => {
    const onChangeHandler = () => {
        if (props.isNested) {
            triggerNestedFieldEvent(props.screenId, props.parentElementId, props.fieldProperties, 'onChange', props.handlersArguments.rowValue._id, props.handlersArguments.rowValue);
        }
        else {
            triggerFieldEvent(props.screenId, props.elementId, 'onChange');
        }
    };
    const onClick = () => {
        if (props.isNested) {
            triggerNestedFieldEvent(props.screenId, props.parentElementId, props.fieldProperties, 'onClick', props.handlersArguments.rowValue._id, props.handlersArguments.rowValue);
        }
        else {
            triggerFieldEvent(props.screenId, props.elementId, 'onClick');
        }
    };
    const onChange = (event) => {
        const value = event.target.checked;
        if (props.value !== value) {
            handleChange(props.elementId, value, props.setFieldValue, props.validate, onChangeHandler);
        }
    };
    const switchRef = React.useRef(null);
    const isReadOnly = isFieldReadOnly(props.screenId, props.fieldProperties, props.value, props.handlersArguments?.rowValue);
    const isDisabled = isFieldDisabled(props.screenId, props.fieldProperties, props.value, props.handlersArguments?.rowValue);
    const commonProps = getCommonCarbonComponentProperties(props);
    // Carbon throws an error if a validation error is passed on to disabled fields
    if (commonProps.error && (isReadOnly || isDisabled)) {
        delete commonProps.error;
    }
    return (React.createElement(CarbonWrapper, { ...props, className: "e-switch-field", componentName: "switch", componentRef: switchRef, handlersArguments: props.handlersArguments, noReadOnlySupport: true, value: !!props.value || false, readOnlyDisplayValue: props.value
            ? localize('@sage/xtrem-ui/switch-on-caps', 'ON')
            : localize('@sage/xtrem-ui/switch-off-caps', 'OFF') },
        React.createElement(Switch, { ref: switchRef, ...commonProps, checked: !!props.value || false, disabled: isDisabled || isReadOnly, labelHelp: props.fieldProperties.title ? props.fieldProperties.titleHelp : undefined, onChange: onChange, onClick: onClick, reverse: true, size: props.fieldProperties.size, value: "checked" })));
});
SwitchComponent.displayName = 'SwitchComponent';
export const ConnectedSwitchComponent = connect(mapStateToProps(), mapDispatchToProps())(SwitchComponent);
export default ConnectedSwitchComponent;
//# sourceMappingURL=switch-component.js.map