import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedSwitchComponent = React.lazy(() => import('./switch-component'));
export function AsyncConnectedSwitchComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedSwitchComponent, { ...props })));
}
const SwitchComponent = React.lazy(() => import('./switch-component').then(c => ({ default: c.SwitchComponent })));
export function AsyncSwitchComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(SwitchComponent, { ...props })));
}
//# sourceMappingURL=async-switch-component.js.map