import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { StepSequenceControlObject } from './step-sequence-control-object';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { addOptionTypeToProperties } from '../../../utils/data-type-utils';
class StepSequenceDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = StepSequenceControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addOptionTypeToProperties({ propertyDetails, dataType, properties });
        return properties;
    }
}
export function stepSequenceField(properties) {
    return standardDecoratorImplementation(properties, StepSequenceDecorator, FieldKey.StepSequence);
}
export function stepSequenceFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=step-sequence-decorator.js.map