/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { StaticContentControlObject } from './static-content-control-object';
class StaticContentDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = StaticContentControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
export function staticContentField(properties) {
    return standardDecoratorImplementation(properties, StaticContentDecorator, FieldKey.StaticContent);
}
export function staticContentFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=static-content-decorator.js.map