import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { BaseControlObject } from '../../base-control-object';
import type { FieldControlObjectConstructorProps } from '../../types';
import { FieldKey } from '../../types';
import type { SeparatorProperties } from './separator-types';
export declare class SeparatorControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends BaseControlObject<CT, SeparatorProperties> {
    layout: FieldControlObjectConstructorProps<FieldKey.Separator>['layout'];
    parent?: FieldControlObjectConstructorProps<FieldKey.Separator>['parent'];
    insertBefore?: FieldControlObjectConstructorProps<FieldKey.Separator>['insertBefore'];
    insertAfter?: FieldControlObjectConstructorProps<FieldKey.Separator>['insertAfter'];
    static defaultUiProperties: Partial<SeparatorProperties>;
    constructor({ screenId, elementId, getUiComponentProperties, setUiComponentProperties, layout, parent, }: FieldControlObjectConstructorProps<FieldKey.Separator>);
    /** Whether the HTML element is visible or not */
    isHidden?: boolean;
    /** It makes the separator element invisible. The separator still preserves its space in the layout, but the line is not displayed. */
    isInvisible?: boolean;
}
//# sourceMappingURL=separator-control-object.d.ts.map