import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedSeparatorComponent = React.lazy(() => import('./separator-component'));
export function AsyncConnectedSeparatorComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedSeparatorComponent, { ...props })));
}
const SeparatorComponent = React.lazy(() => import('./separator-component').then(e => ({ default: e.SeparatorComponent })));
export function AsyncSeparatorComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: "200px" }) },
        React.createElement(SeparatorComponent, { ...props })));
}
//# sourceMappingURL=async-separator-component.js.map