import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { SelectionCardDecoratorProperties } from './selection-card-types';
/**
 * Initializes the decorated member as a [SelectionCard]{@link SelectionCardControlObject} field with the provided properties
 *
 * @param properties The properties that the [SelectionCard]{@link SelectionCardControlObject} field will be initialized with
 */
export declare function selectionCard<T extends ScreenExtension<T>>(properties: SelectionCardDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function selectionCardOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<SelectionCardDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=selection-card-decorator.d.ts.map