import { addDisabledToProperties, addOptionTypeToProperties } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { SelectControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class SelectDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = SelectControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addOptionTypeToProperties({ propertyDetails, dataType, properties });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [Select]{@link SelectControlObject} field with the provided properties
 *
 * @param properties The properties that the [Select]{@link SelectControlObject} field will be initialized with
 */
export function selectField(properties) {
    return standardDecoratorImplementation(properties, SelectDecorator, FieldKey.Select);
}
export function selectFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=select-decorator.js.map