import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { SelectDecoratorProperties, SelectExtensionDecoratorProperties } from './select-types';
/**
 * Initializes the decorated member as a [Select]{@link SelectControlObject} field with the provided properties
 *
 * @param properties The properties that the [Select]{@link SelectControlObject} field will be initialized with
 */
export declare function selectField<T extends ScreenExtension<T>>(properties: SelectDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function selectFieldOverride<T extends ScreenExtension<T>>(properties: SelectExtensionDecoratorProperties<T>): (target: T, name: string) => void;
//# sourceMappingURL=select-decorator.d.ts.map