var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { FieldControlObjectResolvedProperty } from '../../property-decorators/control-object-resolved-property-decorator';
import { getValidOptionValuesForSelect } from './select-utils';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values
 */
export class SelectControlObject extends EditableFieldControlObject {
    /**
     * The GraphQL node that the select options will be fetched from.
     * When using this property, the node must be an Enum
     */
    get optionType() {
        return this.getUiComponentProperty('optionType');
    }
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
    /** Field's value, only valid options can be set as value. */
    set value(newValue) {
        const validOptions = getValidOptionValuesForSelect(this.options || [], this.optionType);
        if (newValue === null || validOptions.indexOf(newValue) !== -1) {
            this._setValue(newValue);
        }
        else {
            throw new Error(`${newValue} is not a valid option of the ${this.elementId} field. Valid options: ${validOptions.join(', ')}`);
        }
    }
    /** Field's value, only valid options can be set as value. */
    get value() {
        return this._getValue() || null;
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], SelectControlObject.prototype, "helperText", void 0);
__decorate([
    ControlObjectProperty()
    /** Icon of the input field. It will be placed on the right side. */
], SelectControlObject.prototype, "icon", void 0);
__decorate([
    ControlObjectProperty()
    /** Color of the icon, only supported in tile containers */
], SelectControlObject.prototype, "iconColor", void 0);
__decorate([
    ControlObjectProperty()
    /** Indicator, whether sounds play on successful/erroneous selection */
], SelectControlObject.prototype, "isSoundDisabled", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
    /** Options to be displayed in the select element */
], SelectControlObject.prototype, "options", void 0);
__decorate([
    ControlObjectProperty()
    /** Placeholder to be displayed in the field body */
], SelectControlObject.prototype, "placeholder", void 0);
//# sourceMappingURL=select-control-object.js.map