import * as React from 'react';
import type { SelectItem } from '../../ui/select/select-component';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { SelectComponentProps, SelectDecoratorProperties, SelectAdditionalProperties } from './select-types';
export declare class SelectComponent extends EditableFieldBaseComponent<SelectDecoratorProperties, string, SelectAdditionalProperties, {}> {
    static resolveDisplayValueFromProps(props: SelectComponentProps, value?: string): string;
    private readonly onInputValueChanged;
    onChange: (selectedItem: SelectItem | undefined, isOrganicChange: boolean) => void;
    getItems: (searchText: string) => Promise<SelectItem[]>;
    render(): React.ReactNode;
}
export declare const ConnectedSelectComponent: import("react-redux").ConnectedComponent<typeof SelectComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<SelectComponent> | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../../../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedSelectComponent;
//# sourceMappingURL=select-component.d.ts.map