import React from 'react';
export const SelectRenderer = React.memo(props => {
    const { fieldProperties, tableElementId } = props;
    if (props.data && props.colDef.field) {
        return (React.createElement(fieldProperties.wrapper, { ...props },
            React.createElement("div", { style: { display: 'flex', alignItems: 'center' } },
                React.createElement("span", { "data-testid": `${tableElementId}-${props.node.rowIndex}-${props.api.getColumns().indexOf(props.column) + 1}` }, props.localizedOptions?.[props.value] ?? props.value))));
    }
    return null;
});
SelectRenderer.displayName = 'SelectRenderer';
//# sourceMappingURL=select-cell-renderer.js.map