import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedSelectComponent = React.lazy(() => import('./select-component'));
export function AsyncConnectedSelectComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedSelectComponent, { ...props })));
}
const SelectComponent = React.lazy(() => import('./select-component').then(c => ({ default: c.SelectComponent })));
export function AsyncSelectComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(SelectComponent, { ...props })));
}
//# sourceMappingURL=async-select-component.js.map