/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { RichTextControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class RichTextDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = RichTextControlObject;
    }
}
/**
 * Initializes the decorated member as a [RichText]{@link RichTextControlObject} field with the provided properties
 *
 * @param properties The properties that the [RichText]{@link RichTextControlObject} field will be initialized with
 */
export function richTextField(properties) {
    return standardDecoratorImplementation(properties, RichTextDecorator, FieldKey.RichText);
}
export function richTextFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=rich-text-decorator.js.map