/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { RichTextDecoratorProperties } from './rich-text-types';
/**
 * Initializes the decorated member as a [RichText]{@link RichTextControlObject} field with the provided properties
 *
 * @param properties The properties that the [RichText]{@link RichTextControlObject} field will be initialized with
 */
export declare function richTextField<T extends ScreenExtension<T>>(properties: RichTextDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function richTextFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<RichTextDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=rich-text-decorator.d.ts.map