/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { RichTextProperties } from './rich-text-types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a rich, formatted text value
 */
export declare class RichTextControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.RichText, FieldComponentProps<FieldKey.RichText>> {
    static readonly defaultUiProperties: Partial<RichTextProperties>;
    /** The value of the height attribute of the HTML image (e.g. 100px, 75%, auto, etc.) */
    height?: string;
    /** Field's value */
    get value(): string | null;
    /** Field's value */
    set value(newValue: string);
}
//# sourceMappingURL=rich-text-control-object.d.ts.map