import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedRichTextComponent = React.lazy(() => import('./rich-text-component'));
export function AsyncConnectedRichTextComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedRichTextComponent, { ...props })));
}
const RichTextComponent = React.lazy(() => import('./rich-text-component').then(c => ({ default: c.RichTextComponent })));
export function AsyncRichTextComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(RichTextComponent, { ...props })));
}
//# sourceMappingURL=async-rich-text-component.js.map