/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { RelativeDateControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class RelativeDateDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = RelativeDateControlObject;
    }
}
/**
 * Initializes the decorated member as a [Progress]{@link ProgressControlObject} field with the provided properties
 *
 * @param properties The properties that the [Progress]{@link ProgressControlObject} field will be initialized with
 */
export function relativeDateField(properties) {
    return standardDecoratorImplementation(properties, RelativeDateDecorator, FieldKey.RelativeDate);
}
export function relativeDateFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=relative-date-decorator.js.map