/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { RelativeDateDecoratorProperties } from './relative-date-types';
/**
 * Initializes the decorated member as a [Progress]{@link ProgressControlObject} field with the provided properties
 *
 * @param properties The properties that the [Progress]{@link ProgressControlObject} field will be initialized with
 */
export declare function relativeDateField<T extends ScreenExtension<T>>(properties: RelativeDateDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function relativeDateFieldOverride<T extends ScreenExtension<T>>(properties: ClickableOverrideDecoratorProperties<RelativeDateDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=relative-date-decorator.d.ts.map