import * as React from 'react';
import { RelativeDate } from '../../ui/relative-date/relative-date-component';
export function RelativeDateCellRenderer(props) {
    const { value } = props;
    if (value === undefined || value === '' || Number.isNaN(value)) {
        return null;
    }
    return (React.createElement(props.fieldProperties.wrapper, { ...props },
        React.createElement(RelativeDate, { value: value, scope: props.colDef?.cellRendererParams?.relativeDateScope ?? 'datetime' })));
}
//# sourceMappingURL=relative-date-cell-renderer.js.map