var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { noop } from 'lodash';
import { lookupDialog } from '../../../service/dialog-service';
import { fetchReferenceFieldSuggestions } from '../../../service/graphql-service';
import { showToast } from '../../../service/toast-service';
import { handleChange } from '../../../utils/abstract-fields-utils';
import { triggerFieldEvent } from '../../../utils/events';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { splitValueToMergedValue } from '../../../utils/transformers';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { getReferenceValueField } from './reference-utils';
import { setFieldValue } from '../../../redux/actions';
import { getStore } from '../../../redux';
/**
 * [Field]{@link EditableFieldControlObject} that holds a reference to an existing GraphQL object. The type of GraphQL object
 * must be specified through the 'node' property, while the 'valueField' and 'helperTextField'
 * properties define which properties of the GraphQL object will be displayed in the field
 * and will be matched against the user provided text
 */
export class ReferenceControlObject extends EditableFieldControlObject {
    static { this.defaultUiProperties = {
        ...EditableFieldControlObject.defaultUiProperties,
        canFilter: true,
        isAutoSelectEnabled: false,
    }; }
    /** Graphql filter that will restrict the results of the reference field */
    get filter() {
        return resolveByValue({
            fieldValue: undefined,
            propertyValue: this.getUiComponentProperty('filter'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        if (!this.getUiComponentProperty('isTransient')) {
            this.refresh().catch(() => {
                /* Intentional fire and forget */
            });
        }
    }
    /** The GraphQL node property that will be displayed below the reference field */
    get helperTextField() {
        return this.getUiComponentProperty('helperTextField');
    }
    /** The GraphQL node property that will be used to display an image in front of the values. t*/
    get imageField() {
        return this.getUiComponentProperty('imageField');
    }
    /** The GraphQL node that the field suggestions will be fetched from */
    get node() {
        return String(this.getUiComponentProperty('node'));
    }
    /** Field's value */
    get value() {
        const value = this._getValue();
        return value ? splitValueToMergedValue(value) : null;
    }
    /** Field's value */
    set value(newValue) {
        /** *
         *  $ / _ hack: if the value has an `_id` value, we transform it to `_id`.
         * We will streamline these properties for R2
         *
         *  */
        if (newValue && newValue.$id) {
            const remappedValue = { ...newValue, _id: newValue.$id };
            delete remappedValue.$id;
            this._setValue(remappedValue);
        }
        else {
            this._setValue(newValue);
        }
    }
    /** The GraphQL node property that will be used as the reference field value */
    get valueField() {
        return getReferenceValueField(this.uiComponentProperties);
    }
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
    openDialog() {
        this.setUiComponentProperties('isReferenceDialogOpen', true);
        lookupDialog(this.screenId, 'info', {
            contextNode: this.getUiComponentProperty('node'),
            createTunnelLinkText: this.getUiComponentProperty('createTunnelLinkText'),
            fieldId: this.elementId,
            fieldProperties: this._getUiComponentProperties(this.screenId, this.elementId),
            isLinkCreateNewText: !!this.getUiComponentProperty('tunnelPage'),
            isMultiSelect: false,
            level: undefined,
            onCreateNewItemLinkClick: undefined,
            parentElementId: undefined,
            recordContext: undefined,
            searchText: undefined,
            selectedRecordId: this.value?._id,
            value: this.value,
            valueField: this.getUiComponentProperty('valueField'),
        })
            .catch(noop)
            .then(([selection]) => {
            const { dispatch, getState } = getStore();
            handleChange(this.elementId, selection ?? null, async () => {
                await setFieldValue(this.screenId, this.elementId, selection, true)(dispatch, getState);
            }, this.validateWithDetails.bind(this), () => {
                triggerFieldEvent(this.screenId, this.elementId, 'onChange');
            });
        });
    }
    async fetchSuggestions(searchText) {
        const result = await fetchReferenceFieldSuggestions({
            fieldProperties: this.properties,
            screenId: this.screenId,
            fieldId: this.elementId,
            filterValue: searchText,
        });
        if (result) {
            // The remove edges function return an object with integer keys so we need to convert it back to an array.
            return Object.values(result).map((e) => splitValueToMergedValue(e));
        }
        return [];
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], ReferenceControlObject.prototype, "helperText", void 0);
__decorate([
    ControlObjectProperty()
    /** Icon of the input field. It will be placed on the right side. */
], ReferenceControlObject.prototype, "icon", void 0);
__decorate([
    ControlObjectProperty()
    /** Color of the icon, only supported in tile containers */
], ReferenceControlObject.prototype, "iconColor", void 0);
__decorate([
    ControlObjectProperty()
    /** Indicator, whether sounds play on successful/erroneous selection */
], ReferenceControlObject.prototype, "isSoundDisabled", void 0);
__decorate([
    ControlObjectProperty()
    /** Placeholder to be displayed in the field body */
], ReferenceControlObject.prototype, "placeholder", void 0);
__decorate([
    ControlObjectProperty()
    /** Lookup Dialog title **/
], ReferenceControlObject.prototype, "lookupDialogTitle", void 0);
//# sourceMappingURL=reference-control-object.js.map