/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey, PartialCollectionValue } from '../../types';
import type { ReferenceDecoratorProperties } from './reference-types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a reference to an existing GraphQL object. The type of GraphQL object
 * must be specified through the 'node' property, while the 'valueField' and 'helperTextField'
 * properties define which properties of the GraphQL object will be displayed in the field
 * and will be matched against the user provided text
 */
export declare class ReferenceControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Reference, FieldComponentProps<FieldKey.Reference>> {
    static readonly defaultUiProperties: Partial<ReferenceDecoratorProperties<ScreenBase>>;
    /** Graphql filter that will restrict the results of the reference field */
    get filter(): GraphQLFilter<ReferencedItemType> | ((this: CT) => GraphQLFilter<ReferencedItemType>) | undefined;
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter: GraphQLFilter<ReferencedItemType> | ((this: CT) => GraphQLFilter<ReferencedItemType>) | undefined);
    /** The GraphQL node property that will be displayed below the reference field */
    get helperTextField(): string | undefined;
    /** The GraphQL node property that will be used to display an image in front of the values. t*/
    get imageField(): string | undefined;
    /** The GraphQL node that the field suggestions will be fetched from */
    get node(): string;
    /** The helper text underneath the field */
    helperText?: string;
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Color of the icon, only supported in tile containers */
    iconColor?: string;
    /** Indicator, whether sounds play on successful/erroneous selection */
    isSoundDisabled?: boolean;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** Lookup Dialog title **/
    lookupDialogTitle?: string;
    /** Field's value */
    get value(): PartialCollectionValue<ReferencedItemType> | null;
    /** Field's value */
    set value(newValue: PartialCollectionValue<ReferencedItemType> | null);
    /** The GraphQL node property that will be used as the reference field value */
    get valueField(): string | undefined;
    refresh(): Promise<void>;
    /** Moves the browser focus to this field */
    focus(): void;
    openDialog(): void;
    fetchSuggestions(searchText?: string): Promise<PartialCollectionValue<ReferencedItemType>[]>;
}
//# sourceMappingURL=reference-control-object.d.ts.map