import type { ClientNode } from '@sage/xtrem-client';
import type { UseComboboxStateChangeTypes } from 'downshift';
import * as React from 'react';
import { ContextType } from '../../../types';
import type { LookupDialogContent } from '../../../types/dialogs';
import type { CarbonLinkEvent } from '../../../utils/types';
import type { CollectionItem } from '../../types';
import type { PortraitSize } from '../../ui/portrait-component';
import type { SelectItem } from '../../ui/select/select-component';
import { Select } from '../../ui/select/select-component';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { ConnectedReferenceComponentProps, ReferenceComponentState, ReferenceDecoratorProperties } from './reference-types';
export declare class ReferenceComponent<T extends ClientNode = any> extends EditableFieldBaseComponent<ReferenceDecoratorProperties<any, T>, T, ConnectedReferenceComponentProps<T>, ReferenceComponentState> {
    private readonly lookupButtonRef;
    private readonly selectInputRef;
    private searchText;
    constructor(props: ConnectedReferenceComponentProps<T>);
    private readonly onInputValueChanged;
    private lookupDialogControl?;
    componentDidMount(): void;
    getIsReferenceDialogOpen: () => boolean;
    onChange: (collectionItem: CollectionItem | undefined, isOrganicChange: boolean) => void;
    onMobileButtonClick: (event: React.MouseEvent<HTMLElement>) => void;
    onButtonClick: (event: CarbonLinkEvent) => void;
    getLookupContent: () => LookupDialogContent;
    openLookupDialog: () => Promise<void>;
    hasLookupIcon: () => boolean;
    isLookupDialogOpen: () => boolean;
    isLookupDialogOpenMobile: () => boolean;
    isReadOnlyAndHasPicture: () => boolean;
    render(): React.ReactNode;
    handleOnCreateNewItemLinkClick: () => void;
    renderMobile: (className: string) => React.ReactNode;
    onOpenTunnel: (isNew?: boolean) => Promise<void>;
    getHelperTextLink: () => string | undefined;
    onInputChange: (searchText: string, type?: UseComboboxStateChangeTypes) => Promise<void>;
    getPortraitSize: () => PortraitSize;
    onItemsFetched: React.ComponentProps<typeof Select>['onItemsFetched'];
    getItems: (filterValue: string) => Promise<SelectItem[]>;
    getMinLookupCharacters: () => number;
    getMinLookupCharactersForMobile: () => number;
    renderDesktop: (className: string) => React.ReactNode;
    isRelatedTargetEqualTo: (e: React.FocusEvent<HTMLInputElement>, input: string) => boolean;
}
export declare const ConnectedReferenceComponent: import("react-redux").ConnectedComponent<typeof ReferenceComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<ReferenceComponent<ClientNode>> | undefined;
    bind?: import("./reference-types").PropertyValueType<ClientNode | any>;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedReferenceComponent;
//# sourceMappingURL=reference-component.d.ts.map