import React from 'react';
import type { CarbonLinkEvent } from '../../../utils/types';
import type { NestedReferenceProperties } from '../../decorators';
import type { ReferenceCellRendererProps } from './reference-types';
import type { ImageValue } from '../image/image-types';
export declare class ReferenceCellRenderer extends React.Component<ReferenceCellRendererProps> {
    private readonly linkRef;
    componentDidMount(): void;
    shouldComponentUpdate(nextProps: ReferenceCellRendererProps): boolean;
    componentWillUnmount(): void;
    private readonly onFocus;
    /**
     * Searches for the reference field image from the row using the the dot path, first using the bind path of the reference column, then the path of the `imageField`;
     * @returns
     */
    getImageFromProps: () => ImageValue | undefined;
    private getTunnelPageLink;
    private readonly shouldRenderTunnelPageLink;
    private readonly isReadOnly;
    onTunnelLinkClick: (ev: CarbonLinkEvent) => Promise<void>;
    render(): React.ReactNode;
}
export declare const ConnectedReferenceCellRenderer: import("react-redux").ConnectedComponent<typeof ReferenceCellRenderer, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<ReferenceCellRenderer> | undefined;
    colDef: {
        filter?: any;
        sort?: import("@ag-grid-community/core").SortDirection | undefined;
        type?: string | string[] | undefined;
        hide?: boolean | undefined;
        width?: number | undefined;
        maxWidth?: number | undefined;
        context: {
            columnId: string;
            xtremSortIndex?: number;
            screenId: string;
            columnDefinition?: import("../../nested-fields").NestedField<import("../../../service/screen-base").ScreenBase, import("../../nested-fields").NestedFieldTypes>;
            isEditable: (data: any) => boolean;
        };
        equals?: ((valueA: any, valueB: any) => boolean) | undefined;
        aggFunc?: string | import("@ag-grid-community/core").IAggFunc<any, any> | null | undefined;
        flex?: number | undefined;
        colSpan?: ((params: import("@ag-grid-community/core").ColSpanParams<any, any>) => number) | undefined;
        rowSpan?: ((params: import("@ag-grid-community/core").RowSpanParams<any, any>) => number) | undefined;
        suppressAutoSize?: boolean | undefined;
        singleClickEdit?: boolean | undefined;
        loadingCellRenderer?: any;
        loadingCellRendererParams?: any;
        loadingCellRendererSelector?: import("@ag-grid-community/core").CellRendererSelectorFunc<any, any> | undefined;
        enableCellChangeFlash?: boolean | undefined;
        rowDragText?: ((params: import("@ag-grid-community/core").IRowDragItem, dragItemCount: number) => string) | undefined;
        sortingOrder?: import("@ag-grid-community/core").SortDirection[] | undefined;
        unSortIcon?: boolean | undefined;
        icons?: {
            [key: string]: ((...args: any[]) => any) | string;
        } | undefined;
        onCellValueChanged?: ((event: import("@ag-grid-community/core").NewValueParams<any, any>) => void) | undefined;
        onCellClicked?: ((event: import("@ag-grid-community/core").CellClickedEvent<any, any>) => void) | undefined;
        onCellDoubleClicked?: ((event: import("@ag-grid-community/core").CellDoubleClickedEvent<any, any>) => void) | undefined;
        onCellContextMenu?: ((event: import("@ag-grid-community/core").CellContextMenuEvent<any, any>) => void) | undefined;
        autoHeight?: boolean | undefined;
        suppressNavigable?: boolean | import("@ag-grid-community/core").SuppressNavigableCallback<any, any> | undefined;
        suppressKeyboardEvent?: ((params: import("@ag-grid-community/core").SuppressKeyboardEventParams<any, any>) => boolean) | undefined;
        contextMenuItems?: (string | import("@ag-grid-community/core").MenuItemDef<any, any>)[] | import("@ag-grid-community/core").GetContextMenuItems<any, any> | undefined;
        headerTooltip?: string | undefined;
        headerClass?: import("@ag-grid-community/core").HeaderClass<any, any> | undefined;
        headerComponent?: any;
        headerComponentParams?: any;
        mainMenuItems?: (string | import("@ag-grid-community/core").MenuItemDef<any, any>)[] | import("@ag-grid-community/core").GetMainMenuItems<any, any> | undefined;
        suppressHeaderContextMenu?: boolean | undefined;
        suppressHeaderMenuButton?: boolean | undefined;
        suppressHeaderKeyboardEvent?: ((params: import("@ag-grid-community/core").SuppressHeaderKeyboardEventParams<any, any>) => boolean) | undefined;
        pinned?: boolean | "left" | "right" | null | undefined;
        lockPinned?: boolean | undefined;
        initialPinned?: boolean | "left" | "right" | undefined;
        cellAriaRole?: string | undefined;
        cellStyle?: import("@ag-grid-community/core").CellStyle | import("@ag-grid-community/core").CellStyleFunc<any, any> | undefined;
        cellClass?: string | string[] | import("@ag-grid-community/core").CellClassFunc<any, any> | undefined;
        cellClassRules?: import("@ag-grid-community/core").CellClassRules<any, any> | undefined;
        cellRenderer?: any;
        cellRendererSelector?: import("@ag-grid-community/core").CellRendererSelectorFunc<any, any> | undefined;
        rowDrag?: boolean | import("@ag-grid-community/core").RowDragCallback<any, any> | undefined;
        dndSource?: boolean | import("@ag-grid-community/core").DndSourceCallback<any, any> | undefined;
        dndSourceOnRowDrag?: ((params: import("@ag-grid-community/core").DndSourceOnRowDragParams<any>) => void) | undefined;
        sortable?: boolean | undefined;
        initialSort?: import("@ag-grid-community/core").SortDirection | undefined;
        sortIndex?: number | null | undefined;
        initialSortIndex?: number | undefined;
        tooltipField?: string | undefined;
        tooltipValueGetter?: ((params: import("@ag-grid-community/core").ITooltipParams<any, any, any>) => string | any) | undefined;
        tooltipComponent?: any;
        tooltipComponentParams?: any;
        initialWidth?: number | undefined;
        minWidth?: number | undefined;
        initialFlex?: number | undefined;
        resizable?: boolean | undefined;
        suppressSizeToFit?: boolean | undefined;
        editable?: boolean | import("@ag-grid-community/core").EditableCallback<any, any> | undefined;
        pivot?: boolean | undefined;
        field: string;
        colId?: string | undefined;
        cellDataType?: boolean | string | undefined;
        valueGetter?: string | import("@ag-grid-community/core").ValueGetterFunc<any, any> | undefined;
        valueFormatter?: string | import("@ag-grid-community/core").ValueFormatterFunc<any, any> | undefined;
        refData?: {
            [key: string]: string;
        } | undefined;
        keyCreator?: ((params: import("@ag-grid-community/core").KeyCreatorParams<any, any>) => string) | undefined;
        checkboxSelection?: boolean | import("@ag-grid-community/core").CheckboxSelectionCallback<any, any> | undefined;
        showDisabledCheckboxes?: boolean | undefined;
        suppressPaste?: boolean | import("@ag-grid-community/core").SuppressPasteCallback<any, any> | undefined;
        suppressFillHandle?: boolean | undefined;
        initialHide?: boolean | undefined;
        lockVisible?: boolean | undefined;
        lockPosition?: boolean | "left" | "right" | undefined;
        suppressMovable?: boolean | undefined;
        useValueFormatterForExport?: boolean | undefined;
        valueSetter?: string | import("@ag-grid-community/core").ValueSetterFunc<any, any> | undefined;
        valueParser?: string | import("@ag-grid-community/core").ValueParserFunc<any, any> | undefined;
        cellEditor?: any;
        cellEditorParams?: any;
        cellEditorSelector?: import("@ag-grid-community/core").CellEditorSelectorFunc<any, any> | undefined;
        cellEditorPopup?: boolean | undefined;
        cellEditorPopupPosition?: "over" | "under" | undefined;
        useValueParserForImport?: boolean | undefined;
        getQuickFilterText?: ((params: import("@ag-grid-community/core").GetQuickFilterTextParams<any, any>) => string) | undefined;
        filterValueGetter?: string | import("@ag-grid-community/core").ValueGetterFunc<any, any> | undefined;
        floatingFilter?: boolean | undefined;
        suppressFloatingFilterButton?: boolean | undefined;
        menuTabs?: import("@ag-grid-community/core").ColumnMenuTab[] | undefined;
        columnChooserParams?: import("@ag-grid-community/core").ColumnChooserParams | undefined;
        columnsMenuParams?: import("@ag-grid-community/core").ColumnsMenuParams | undefined;
        suppressMenu?: boolean | undefined;
        suppressHeaderFilterButton?: boolean | undefined;
        headerCheckboxSelection?: boolean | import("@ag-grid-community/core").HeaderCheckboxSelectionCallback<any, any> | undefined;
        headerCheckboxSelectionFilteredOnly?: boolean | undefined;
        headerCheckboxSelectionCurrentPageOnly?: boolean | undefined;
        chartDataType?: "category" | "series" | "time" | "excluded" | undefined;
        initialPivot?: boolean | undefined;
        pivotIndex?: number | null | undefined;
        initialPivotIndex?: number | undefined;
        pivotComparator?: ((valueA: string, valueB: string) => number) | undefined;
        enablePivot?: boolean | undefined;
        wrapText?: boolean | undefined;
        suppressCellFlash?: boolean | undefined;
        rowGroup?: boolean | undefined;
        initialRowGroup?: boolean | undefined;
        rowGroupIndex?: number | null | undefined;
        initialRowGroupIndex?: number | undefined;
        enableRowGroup?: boolean | undefined;
        enableValue?: boolean | undefined;
        initialAggFunc?: string | import("@ag-grid-community/core").IAggFunc<any, any> | undefined;
        defaultAggFunc?: string | undefined;
        allowedAggFuncs?: string[] | undefined;
        showRowGroup?: string | boolean | undefined;
        comparator?: ((valueA: any, valueB: any, nodeA: import("@ag-grid-community/core").IRowNode<any>, nodeB: import("@ag-grid-community/core").IRowNode<any>, isDescending: boolean) => number) | undefined;
        pivotValueColumn?: (import("@ag-grid-community/core").Column | null) | undefined;
        pivotTotalColumnIds?: string[] | undefined;
        suppressSpanHeaderHeight?: boolean | undefined;
        headerName?: string | undefined;
        headerValueGetter?: string | import("@ag-grid-community/core").HeaderValueGetterFunc<any, any> | undefined;
        columnGroupShow?: import("@ag-grid-community/core").ColumnGroupShowType | undefined;
        toolPanelClass?: import("@ag-grid-community/core").ToolPanelClass<any, any> | undefined;
        suppressColumnsToolPanel?: boolean | undefined;
        suppressFiltersToolPanel?: boolean | undefined;
        pivotKeys?: string[] | undefined;
        wrapHeaderText?: boolean | undefined;
        autoHeaderHeight?: boolean | undefined;
        filterParams?: any;
        floatingFilterComponent?: any;
        floatingFilterComponentParams?: any;
    } & {
        cellRendererParams: import("../../../utils/ag-grid/ag-grid-column-config").CellProps<NestedReferenceProperties<import("../../../service/screen-base").ScreenBase<any, any>, any, any>>;
    };
    value: string;
    node: import("@ag-grid-community/core").RowNode;
    column: import("@ag-grid-community/core").Column;
    data: any;
    context: any;
    fullWidth?: boolean | undefined;
    api: import("@ag-grid-community/core").GridApi<any>;
    pinned?: "left" | "right" | null | undefined;
    valueFormatted: string | null | undefined;
    eGridCell: HTMLElement;
    eParentOfValue: HTMLElement;
    getValue?: (() => any) | undefined;
    setValue?: ((value: any) => void) | undefined;
    formatValue?: ((value: any) => string) | undefined;
    refreshCell?: (() => void) | undefined;
    registerRowDragger: (rowDraggerElement: HTMLElement, dragStartPixels?: number, value?: string, suppressVisibilityChange?: boolean) => void;
    setTooltip: (value: string, shouldDisplayTooltip?: () => boolean) => void;
    eventKey: string | null;
    initialValue: any;
    onValueChange: (value: any) => void;
    stopEditing: (suppressNavigateAfterEdit?: boolean) => void;
    columnId: string;
    contextNode?: keyof import("../../..").PageNode<import("../../../service/screen-base").ScreenBase> | undefined;
    elementId: string;
    fieldProperties: import("../../../utils/ag-grid/ag-grid-column-config").WithNestedWrapper<NestedReferenceProperties<import("../../../service/screen-base").ScreenBase<any, any>, any, any>>;
    isEditing?: boolean | undefined;
    isParentFieldDisabled: boolean;
    isTableReadOnly?: import("../../../utils/types").ValueOrCallbackWithFieldValue<import("../../../service/screen-base").ScreenBase<any, any>, boolean>;
    isTree: boolean;
    locale: import("@sage/xtrem-shared/lib/locale").LocalizeLocale;
    screenId: string;
    tableElementId: string;
    collectionValue: () => import("../../../service/collection-data-service").CollectionValue;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedReferenceCellRenderer;
//# sourceMappingURL=reference-cell-renderer.d.ts.map