import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedRadioComponent = React.lazy(() => import('./radio-component'));
export function AsyncConnectedRadioComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedRadioComponent, { ...props })));
}
const RadioComponent = React.lazy(() => import('./radio-component').then(c => ({ default: c.RadioComponent })));
export function AsyncRadioComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(RadioComponent, { ...props })));
}
//# sourceMappingURL=async-radio-component.js.map